 ; Ŀ
 ;   Zen - move entities from Rocket layers to a different standard.       
 ;   Copyright 1994, 1997, 2002, 2005 by Rocket Software Ltd.              
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Calm - relayer block subentities in the block tables.      
 ; 
 (DEFUN CALM (laylst / reww blok enam entt num goon nxt cdrnxt laysub)
  (setq reww t)
  (while (setq blok (tblnext "block" reww))           ; head entity from table
         (setq reww ())
         (grtext -2 (cdr (assoc 2 blok)))
         (setq enam (cdr (assoc -2 blok)))            ; first ename after head
         (while (and enam (setq entt (entget enam)))
                (setq num 0)
                (setq goon t)
                (while (and goon (setq nxt (nth num entt)))
                       (setq num (1+ num))
                       (if (and (= (car nxt) 8)
                                (setq cdrnxt (strcase (cdr nxt) t))
                                (setq laysub (cadr (assoc cdrnxt laylst))))
                           (progn
                                (setq goon ())
                                (entmod (subst (cons 8 laysub) nxt entt)))))
                (setq enam (entnext enam))))
 (princ))
 ; Ŀ
 ;   Calm end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Frenzy - relayer attributes in block insertions.           
 ; 
 (DEFUN FRENZY (laylst / ss len num enam esav entt asoc8 layy laysub gnulay)
  (if (setq ss (ssget "X" (list (cons 0 "INSERT") (cons 66 1))))
      (progn
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)           
           (while (setq enam (setq esav (ssname ss num)))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq
                                                     enam (entnext enam)))))))
                         (if (and (setq asoc8 (assoc 8 entt))
                                  (setq layy (strcase (cdr asoc8) t))
                                  (setq laysub (assoc layy laylst)))
                             (progn
                                  (setq gnulay (cons 8 (cadr laysub)))
                                  (entmod (subst gnulay asoc8 entt)))))
                  (entupd esav))))
 (princ))
 ; Ŀ
 ;   Frenzy end.                                                           
 ; 

 ; Ŀ
 ;   Lapo - Fix the properties of a named layer, make it if it doesn't     
 ;   exist.                                                                
 ;   Arguments: Lanam, a layer name.                                       
 ;              Lacol, a layer color.                                      
 ;              Lint, a linetype.                                          
 ;   Calls nothing, Returns nothing, makes the layer in question current.  
 ; 
 (DEFUN LAPO (lanam lacol lint / lext)
  (if (tblsearch "layer" lanam)
      (command "-layer" "c" lacol lanam "lt" lint lanam "")
      (command "-layer" "m" lanam "c" lacol lanam "lt" lint lanam ""))
 (princ))
 ; Ŀ
 ;   Lapo end.                                                             
 ; 

 ; Ŀ
 ;   Zen.                                                                  
 ; 
 (DEFUN C:ZEN (/ *error* laylst num sublst newlay oldlay ss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *terror* (shk /)
  (if shk (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Make a list of lists of old and new layers and properties.            
 ;   The format is:                                                        
 ;   (Existing_Layer  New_Layer  New_Layer_Colour  New_Layer_Linetype)     
 ;   Existing layer names must be in lower case.                           
 ; 
  (setq laylst (list '("eequip"  "E-Eequip"     "13"  "continuous")
                     '("text"    "E-Text1"      "2"   "continuous")
                     '("text1"   "E-Text1"      "2"   "continuous")
                     '("text2"   "E-Text2"      "3"   "continuous")
                     '("text3"   "E-Text3"      "4"   "continuous")
                     '("busbar"  "E-Busbar"     "4"   "continuous")
                     '("center"  "E-Center"     "1"   "continuous")
                     '("cable"   "E-Cable"      "3"   "continuous")
                     '("cableug" "E-Cable-Ug"   "3"   "dashed")
                     '("field"   "E-Wire-Field" "3"   "dashed")
                     '("panel"   "E-Wire-Panel" "3"   "continuous")
                     '("ground"  "E-Ground"     "4"   "phantom")
                     '("hidden"  "E-Hidden"     "1"   "hidden")
                     '("misc"    "E-Misc"       "5"   "continuous")
                     '("tray"    "E-Cable-Tray" "165" "continuous")))
 ; Ŀ
 ;   Step through the list.  If a new layer exists, move everything on     
 ;   the old layer to it, otherwise rename the old layer.                  
 ; 
  (setq num 0)
  (while (setq sublst (nth num laylst))
         (setq num (1+ num))
         (grtext -2 (setq oldlay (car sublst)))
         (setq newlay (cadr sublst))
 ; Ŀ
 ;   If the new layer doesn't exist then rename the old layer and make     
 ;   sure the properties are correct.                                      
 ; 
         (cond ((and (tblsearch "layer" oldlay)
                     (null (tblsearch "layer" newlay)))
                (command "rename" "layer" oldlay newlay)
                (lapo newlay (nth 2 sublst) (nth 3 sublst)))
 ; Ŀ
 ;   If the new layer exists then update the properties and move           
 ;   everything on the old layer to it.                                    
 ; 
               ((and (tblsearch "layer" oldlay)
                     (tblsearch "layer" newlay)
                     (setq ss (ssget "X" (list (cons 8 oldlay)))))
                (lapo newlay (nth 2 sublst) (nth 3 sublst))
                (command "change" ss "" "P" "La" newlay ""))))
 ; Ŀ
 ;   Now go through the block tables, change any subentity on an old       
 ;   layer to the corresponding new one.                                   
 ; 
  (calm laylst)
 ; Ŀ
 ;   Relayer attributes in block insertions - these are not automatically  
 ;   updated when the block tables are changed.                            
 ; 
  (frenzy laylst)
  (command "undo" "end")
 (princ))